<?php
/**
 * @package WordPress
 * @subpackage Under_the_Influence
 */
load_theme_textdomain('uti_theme');
$themename = "Under the Influence";
$shortname = "uti";
$options = array (

array(    "name" => __("Under the Influence listens.", "uti_theme"),
        "type" => "title"),

array(    "type" => "open"),

array(    "name" => __("Accent Color", "uti_theme"),
        "desc" => __("Default: 900.", "uti_theme"),
        "id" => $shortname."_accent_color",
        "std" => "#9bbc57",
		"id2" => "1",
        "type" => "color"),

array(    "name" => __("Muted Accent Color", "uti_theme"),
        "desc" => __("Affects tags, metadata for posts and comments and the read more hover color. <br>Default: 955", "uti_theme"),
        "id" => $shortname."_muted_accent",
		"std" => "#619500",
		"id2" => "2",
        "type" => "color"),

array(    "name" => __("Font Replacement", "uti_theme"),
        "desc" => __("The title font is automatically rendered in Fertigo Pro 400 (by Jos Buivenga -> www.exljbris.com). Disabling it reverts the title to Georgia.<br>Default: on", "uti_theme"),
        "id" => $shortname."_font_replacement",
		"std" => "on",
        "type" => "select",
		"options" => array("on", "off")),
	

array(    "name" => __("Default Header Design", "uti_theme"),
        "desc" => __("Default:2", "uti_theme"),
        "id" => $shortname."_header_design",
		"std" => "2",
        "type" => "select",
		 "options" => array("2", "1")),

array(    "name" => __("Extra Links", "uti_theme"),
        "desc" => __("In order to add extra links to the navigation bar at the top enter a url (without http://) and a title separated by a semicolon and a space. You can add as many links as you like. Just make sure to separate everything with a semicolon and a space.<br><em>Example: twitter.com/ueberleben; Le Twitter; www.spaceperson.net; Spaceperson</em><br>Default is blank ", "uti_theme"),
        "id" => $shortname."_extra_link",
		"std" => "",
        "type" => "textarea"),


array(    "name" => __("Exclude Pages from Navigation", "uti_theme"),
        "desc" => __("You can exclude pages from the navigation bar at the top by entering their page id. Separate multiple ids with a comma. <br><em>Example: 2, 3, 9, 13</em><br> Page ids are displayed in the url bar of your browser when you edit a page or in the status bar when you hover over a page title in the page manager of the admin panel. <br>Default is blank", "uti_theme"),
        "id" => $shortname."_excluded_pages",
		"std" => "",
        "type" => "text"),

array(    "name" => __("Site Width", "uti_theme"),
        "desc" => __("Determines the with of the entire layout in pc. Alterations are not recommended for the default three column layout. For a two-column layout it might be useful to slim down the page. The optimal site width is Main Column Width + Sidebar Width + 40. <br>Default: 970", "uti_theme"),
        "id" => $shortname."_site_width",
		"std" => "970",
        "type" => "text"),

array(    "name" => __("Main Column Width", "uti_theme"),
        "desc" => __("Determines the width of the content column for single pages in px. Also affects overview pages (front, archive and search pages) when in two column layout. <br>Default: 780", "uti_theme"),
        "id" => $shortname."_column_width",
		"std" => "780",
        "type" => "text"),

array(    "name" => __("Sidebar Width", "uti_theme"),
        "desc" => __("Determines the width of the sidebar in px. Alterations are not recommended for the default three column layout. <br>Default: 150", "uti_theme"),
        "id" => $shortname."_sidebar_width",
		"std" => "150",
        "type" => "text"),

array(    "name" => __("Max Picture Width", "uti_theme"),
        "desc" => __("Determines the maximal width in px of <strong>right aligned</strong> and <strong>left aligned</strong> pictures on overview pages (front, archive and search pages). <br>Default: 230", "uti_theme"),
        "id" => $shortname."_pic_width",
		"std" => "230",
        "type" => "text"),

array(    "name" => __("Three Column Layout", "uti_theme"),
        "desc" => __("Disabling the three column layout changes overview pages (front, archive and search pages) to a two column layout. <br>Default: on", "uti_theme"),
        "id" => $shortname."_column",
		"std" => "on",
        "type" => "select",
		"options" => array("on", "off")),

array(    "name" => __("Description", "uti_theme"),
        "desc" => __("This allows you to toggle the description in the title. <br>Default: on", "uti_theme"),
        "id" => $shortname."_description",
		"std" => "on",
        "type" => "select",
		"options" => array("on", "off")),

array(    "name" => __("Right Hand Footer Cell", "uti_theme"),
        "desc" => __("You can disable the right hand footer cell to slim down the page. This is especially useful for a thinner two-column layout. <br>Default: on", "uti_theme"),
        "id" => $shortname."_footer_cell4",
		"std" => "on",
        "type" => "select",
		"options" => array("on", "off")),

array(    "name" => __("Show Author", "uti_theme"),
        "desc" => __("This allows you to toggle the author name. <br>Default: off", "uti_theme"),
        "id" => $shortname."_show_author",
		"std" => "off",
        "type" => "select",
		"options" => array("off", "on")),

array(    "type" => "close")

);

function mytheme_add_admin() {

    global $themename, $shortname, $options;

    if ( $_GET['page'] == basename(__FILE__) ) {

        if ( 'save' == $_REQUEST['action'] ) {

                foreach ($options as $value) {
                    update_option( $value['id'], $_REQUEST[ $value['id'] ] ); }

                foreach ($options as $value) {
					if(($value['type'] === "checkbox" or $value['type'] === "multiselect" ) and is_array($_REQUEST[ $value['id'] ])){$_REQUEST[ $value['id'] ]=implode(',',$_REQUEST[ $value['id'] ]);}
                    if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], $_REQUEST[ $value['id'] ]  ); } else { delete_option( $value['id'] ); } }
				
                header("Location: themes.php?page=functions.php&saved=true");
                die;

        } else if( 'reset' == $_REQUEST['action'] ) {

            foreach ($options as $value) {
                delete_option( $value['id'] ); }

            header("Location: themes.php?page=functions.php&reset=true");
            die;

        }
    }

    add_theme_page($themename." Options", "".$themename." Options", 'edit_themes', basename(__FILE__), 'mytheme_admin');

}

add_filter('gallery_style', create_function('$a', 'return "
<div class=\'gallery\'>";'));

define('HEADER_TEXTCOLOR', 'ffffff');
define('HEADER_IMAGE', ''); // %s is the template dir uri
define('HEADER_IMAGE_WIDTH', 980); // use width and height appropriate for your theme
define('HEADER_IMAGE_HEIGHT', 180);

// gets included in the site header
function header_style() {
    ?><style type="text/css">
        #header {
            background: url(<?php header_image(); ?>) no-repeat;
		}
		
	
	<?php 
	$headerimage = get_header_image();
	if ($headerimage != ""){ ?>
	#header h1,#header h1 a,#header h1 a:visited {
			color:#<?php header_textcolor(); ?>;
        }
	#header h1 a:hover{
			border-bottom:2px dotted #<?php header_textcolor(); ?>;
			}
	.description {
		color: #<?php header_textcolor(); ?>;
	}
	<?php } ?>
    </style><?php
}


// gets included in the admin header
function admin_header_style() {
    ?><style type="text/css">
        #headimg {
            width: <?php echo HEADER_IMAGE_WIDTH; ?>px;
            height: <?php echo HEADER_IMAGE_HEIGHT; ?>px;
        }
    </style><?php
}

add_custom_image_header('header_style', 'admin_header_style');




	function add_new_var_to_wp($public_query_vars) {

		$public_query_vars[] = 'css';

		return $public_query_vars;

	}

	function dynamic_css_display(){

		$css = get_query_var('css');

		if ($css == 'css'){

			include_once (TEMPLATEPATH . '/dynamic-css.php');

			exit;

		}

	}

	add_filter('query_vars', 'add_new_var_to_wp');

	add_action('template_redirect', 'dynamic_css_display');


function mytheme_comment($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?> 
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
  <div class="comment-author vcard">
             <?php echo get_avatar($comment,$size='48' ); ?>
          </div><!--.comment-author vcard-->
     <div id="comment-<?php comment_ID(); ?>" class="commentbox">
          <?php if ($comment->comment_approved == '0') : ?>
             <em><?php _e('Your comment is waiting for approval.','uti_theme') ?></em>
             <br />
          <?php endif; ?>
    
          <div class="comment-meta commentmetadata"><cite class="fn"><?php echo get_comment_author_link() ?></cite><br /><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s', 'uti_theme'), get_comment_date(), get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)', 'uti_theme'),'  ','') ?></div><!--.comment-meta-->
	<div class="comment_body">
      <?php comment_text() ?>

      <div class="reply">
         <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
      </div><!--.reply-->
      </div><!--.commentbody-->
     </div><!--#comment-<?php comment_ID(); ?>-->
<?php
        }
function my_init_method() {
	if (!is_admin())
	{
	
wp_deregister_script( 'jquery' );
wp_register_script(   'jquery'
    , 'http://ajax.googleapis.com/ajax/libs/jquery/1.4/jquery.min.js');
wp_deregister_script( 'jmasonry' );
wp_register_script(   'jmasonry'
    , get_bloginfo('template_directory') . '/js/jquery.masonry.min.js');
wp_deregister_script( 'jinit_mason' );
wp_register_script(   'jinit_mason' ,  get_bloginfo('template_directory') . '/js/initializer.js');
}    
}
add_action('init', 'my_init_method');
function custom_pings($comment, $args, $depth) {
   $GLOBALS['comment'] = $comment; ?> 
  
   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
        <div id="comment-<?php comment_ID(); ?>" class="commentbox">
     
    
          <?php if ($comment->comment_approved == '0') : ?>
             <em><?php _e('Your comment is waiting for approval.', 'uti_theme') ?></em>
             <br />
          <?php endif; ?>
    
          <div class="comment-meta commentmetadata"><cite class="fn"><?php echo get_comment_author_link() ?></cite><br /><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>"><?php printf(__('%1$s at %2$s', 'uti_theme'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)', 'uti_theme'),'  ','') ?></div><!--.comment-meta-->
     </div><!--#comment-<?php comment_ID(); ?>-->
<?php
        }

function mytheme_admin() {

    global $themename, $shortname, $options;

    if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
    if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';

?>
<div class="wrap">
<h2><?php echo $themename; ?> settings</h2>

<form method="post">
<input name="save" type="submit" value="<?php _e('Save changes', 'uti_theme')?>" />
<input type="hidden" name="action" value="save" />


<?php foreach ($options as $value) {

switch ( $value['type'] ) {

case "open":
?>
<table width="100%" border="0" style="padding:10px">

<?php break;

case "close":
?>

</table><br />

<?php break;

case "title":
?>
<table width="100%" border="0" style="padding:5px 10px; border-bottom:2px dotted #ccc"><tr>
    <td colspan="2"><h3 style="font-family:Georgia,'Times New Roman',Times,serif; letter-spacing:-1px; font-size:20px"><?php echo $value['name']; ?></h3></td>
</tr>

<?php break;

case 'text':
?>

<tr>
    <td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
    <td width="80%"><input style="width:400px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" /></td>
</tr>

<tr>
    <td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #ccc;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>

<?php
break;

case 'color':
?>
<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.4/jquery.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?php bloginfo('template_directory') ?>/js/farbtastic.js"></script>
<link rel="stylesheet" href="<?php bloginfo('template_directory') ?>/js/farbtastic.css" type="text/css" />
<tr>
    <td width="20%" rowspan="3" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
</tr>
<tr>
    <td width="40%" id="colorpicker<?php echo $value['id2']; ?>"></td>
    <script type="text/javascript">
  $(document).ready(function() {
    $('#colorpicker<?php echo $value['id2']; ?>').farbtastic('#<?php echo $value['id']; ?>');
  });
</script>
</tr>
<tr>
    <td><input style="width:200px;" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?>" /><br><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #ccc;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>

<?php
break;

case 'textarea':
?>

<tr>
    <td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
    <td width="80%"><textarea name="<?php echo $value['id']; ?>" style="width:400px; height:100px;" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_settings( $value['id'] ) != "") { echo get_settings( $value['id'] ); } else { echo $value['std']; } ?></textarea></td>

</tr>

<tr>
    <td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #ccc;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>

<?php
break;

case 'select':
?>
<tr>
    <td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
    <td width="80%"><select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
<?php foreach ($value['options'] as $option) { ?>
		<option <?php if (get_settings( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
</select></td>
</tr>

<tr>
    <td><small><?php echo $value['desc']; ?></small></td>
</tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #ccc;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>



<?php
break;

case 'multiselect':
?>
<tr valign="middle"> 
        <th scope="top" style="text-align:left;"><?php echo $value['name']; ?>:</th>
	<?php if(isset($value['desc'])){?>
	</tr>
	<tr valign="middle"> 
		<td style="width:40%;"><?php echo $value['desc']?></td>
	<?php } ?>
        <td>		
            <select  multiple="multiple" size="3" name="<?php echo $value['id']; ?>[]" id="<?php echo $value['id']; ?>" style="height:50px;">
                <?php $ch_values=explode(',',get_settings( $value['id'] )); 
				$pages = get_pages(); 
				foreach ($pages as $pagg) { ?>
                <option<?php if ( in_array($option,$ch_values)) { echo ' selected="selected"'; }?> value="<?php echo $option; ?>"><?php echo $option; ?></option>
                <?php } ?>
            </select>		<select multiple="multiple" size="10" style="height:250px;" name="<?php echo $value['id']; ?>[]" id="<?php echo $value['id']; ?>"
 > 
 <option value="<?php echo $option; ?>">
<?php echo attribute_escape(__('Select page')); ?></option> 
 <?php 
  $pages = get_pages(); 
  foreach ($pages as $pagg) {
  	$option = '<option value="'.get_page_link($pagg->ID).'">';
	$option .= $pagg->post_title;
	 if ( in_array($option,$ch_values)) { echo ' selected="selected"'; }
	$option .= '</option>';
	echo $option;
  }
 ?>
 
</select>
        </td>
    </tr>
<tr><td colspan=2><hr /></td></tr>

<?php
break;

case "checkbox":
?>
    <tr>
    <td width="20%" rowspan="2" valign="middle"><strong><?php echo $value['name']; ?></strong></td>
        <td width="80%"><?php if ( get_settings($value['id']))
		{ $checked = "checked=\"checked\""; }
			else{ $checked = ""; } ?>
                <input type="checkbox" value="1" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" <?php echo $checked; ?> />
                </td>
    </tr>

    <tr>
        <td><small><?php echo $value['desc']; ?></small></td>
   </tr><tr><td colspan="2" style="margin-bottom:5px;border-bottom:1px dotted #ccc;">&nbsp;</td></tr><tr><td colspan="2">&nbsp;</td></tr>
<div class="rm_input rm_checkbox">
	<label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>

<?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "checked=\"unchecked\"";} ?>
<input value="1" type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>"<?php echo $checked; ?> />

	<small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
 </div>
<?php         break;

}
}
?><p class="submit">
<input name="save" type="submit" value="<?php _e('Save changes', 'uti_theme')?>" />
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="<?php _e('Reset', 'uti_theme')?>" />
<input type="hidden" name="action" value="reset" />
</p>
</form>

<?php
}


add_action('admin_menu', 'mytheme_add_admin'); 

automatic_feed_links();

if ( function_exists('register_sidebar') )
	register_sidebar(array(
			'name' => 'sidebar',			   
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2>',
		'after_title' => '</h2>',
	));
register_sidebar(array(
			'name' => 'footercell-left',			   
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div><div class="divider"/></div>',
		'before_title' => '<h2>',
		'after_title' => '</h2><div class="line"></div>',
	));
register_sidebar(array(
			'name' => 'footercell-mid-left',			   
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div><div class="divider"/></div>',
		'before_title' => '<h2>',
		'after_title' => '</h2><div class="line"></div>',
	));
register_sidebar(array(
			'name' => 'footercell-mid-right',			   
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div><div class="divider"/></div>',
		'before_title' => '<h2>',
		'after_title' => '</h2><div class="line"></div>',
	));
register_sidebar(array(
			'name' => 'footercell-right',			   
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div><div class="divider"/></div>',
		'before_title' => '<h2>',
		'after_title' => '</h2><div class="line"></div>',
	));
?>
