<?php
/**
 * @package WordPress
 * @subpackage Under_the_Influence
 */

// Do not delete these lines
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');
	if ( post_password_required() ) { ?>
		<p class="nocomments"><?php _e('This post is password protected. Enter the password to view comments.', 'uti_theme')?></p>
	<?php
		return;
	}
?>
<!-- You can start editing here. -->
<?php if ( have_comments() ) : ?>
	<?php $comments_by_type = &separate_comments($comments); ?>
    <?php if ( ! empty($comments_by_type['comment']) && empty($comments_by_type['pings'])) : ?>
    <!--There are only comments-->
		<h3 id="comments"><?php comments_number(__('No Comments', 'uti_theme'), __('One Comment', 'uti_theme'), __('% Comments', 'uti_theme' ));?> 
        <?php _e('to &#8220;', 'uti_theme'); echo the_title() ?>&#8221;</h3>
    <?php endif; ?>
	 <?php if ( ! empty($comments_by_type['pings']) && empty($comments_by_type['comment']) ) : ?>
     <!--There are only pings-->
		<h3 id="comments"><?php comments_number('No Trackbacks', 'One Trackback', '% Trackbacks' );?>  <?php _e('to &#8220;', 'uti_theme'); echo the_title() ?>&#8221;</h3>
    <?php endif; ?>
     <?php if ( ! empty($comments_by_type['comment']) && ! empty($comments_by_type['pings']) || (  empty($comments_by_type['comment']) && empty($comments_by_type['pings']))) : ?>
     <!--There are comments and pings or none of both-->
		<h3 id="comments"><?php comments_number('No Responses', 'One Response', '% Responses' );?>  <?php _e('to &#8220;', 'uti_theme'); echo the_title() ?>&#8221;</h3>
    <?php endif; ?>
	<div class="navigation"><?php previous_comments_link() ?>&nbsp;&nbsp;&nbsp;&nbsp;<?php next_comments_link() ?></div>
	<ol class="commentlist">
		<?php wp_list_comments('type=comment&callback=mytheme_comment'); /* Constructs comments as declared in functions.php */ ?>
        <?php if ( ! empty($comments_by_type['comment']) && ! empty($comments_by_type['pings'])) : ?>
         <!--There are comments and pings so a sub-header is inserted-->
        <h3 id="trackback"><?php _e('Trackbacks', 'uti_theme') ?></h3>
        <?php endif; ?>
        <?php wp_list_comments('type=pings&callback=custom_pings'); ?>
	</ol>
	<div class="navigation"><?php previous_comments_link() ?>&nbsp;&nbsp;&nbsp;&nbsp;<?php next_comments_link() ?></div>
 <?php else : // this is displayed if there are no comments so far ?>
	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->
	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
        <br />
		<p class="nocomments"><?php _e('Comments are closed.', 'uti_theme') ?></p>
	<?php endif; ?>
<?php endif; ?>
<?php if ( comments_open() ) : ?>

<div id="respond">

<h3><?php comment_form_title( __('Leave a Reply', 'uti_theme'), __('Leave a Reply to %s', 'uti_theme') ); ?></h3>

<div class="cancel-comment-reply">
	<small><?php cancel_comment_reply_link(); ?></small>
</div>

<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
  <p><?php printf(__('You must be <a href="$s">logged in</a> to comment.', 'uti_theme'), wp_login_url(get_permalink())); ?></p>
<?php else : ?>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<?php if ( is_user_logged_in() ) : ?>

<p><?php _e('Logged in as', 'uti_theme')?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Log out of this account', 'uti_theme')?>"><?php _e('Log out', 'uti_theme')?> &raquo;</a></p>

<?php else : ?>

<p><input type="text" name="author" id="author" value="<?php echo esc_attr($comment_author); ?>" size="22" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> /><label for="author">Name <?php if ($req) _e('(required)', 'uti_theme'); ?></label></p>

<p><input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" size="22" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> /><label for="email"><?php _e('Mail (will not be published)', 'uti_theme')?> <?php if ($req) _e('(required)', 'uti_theme'); ?></label></p>

<p><input type="text" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" size="22" tabindex="3" /><label for="url"><?php _e('Website', 'uti_theme')?></label></p>

<?php endif; ?>

<!--<p><small><strong>XHTML:</strong>Allowed tags: <code><?php echo allowed_tags(); ?></code></small></p>-->

<p><textarea name="comment" id="comment" cols="58" rows="10" tabindex="4"></textarea></p>

<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Submit Comment', 'uti_theme')?>" />
<?php comment_id_fields(); ?>
</p>
<?php do_action('comment_form', $post->ID); ?>

</form>

<?php endif; // If registration required and not logged in ?>
</div>

<?php endif; // if you delete this the sky will fall on your head ?>
