<?php
/**
 * @package WordPress
 * @subpackage Under_the_Influence
 */
?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
     <title><?php echo get_option('blogname'); ?> - <?php _e('Comments on', 'uti_theme')?> <?php the_title(); ?></title>

	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php echo get_option('blog_charset'); ?>" />
	<style type="text/css" media="screen">
		@import url( <?php bloginfo('stylesheet_url'); ?> );
		
	a:hover, .postmetadata a:hover, .tags a:hover {
	color: #900;
	}
	#commentspopup #background{
	background-color:#900;};
	
	</style>

</head>
<body id="commentspopup">
<div id="background">
<h1><a href="" title="<?php echo get_option('blogname'); ?>"><?php echo get_option('blogname'); ?></a></h1></div>

<?php
/* Don't remove these lines. */
add_filter('comment_text', 'popuplinks');
if ( have_posts() ) :
while ( have_posts() ) : the_post();
?>
<h2 id="comments"><?php _e('Comments', 'uti_theme')?></h2>

<p><small><a href="<?php echo get_post_comments_feed_link($post->ID); ?>" title="<?php _e('RSS Feed for the comments to this post', 'uti_theme')?>"><?php _e('RSS Feed', 'uti_theme')?></a><?php if ( pings_open() ) { ?>&nbsp;&nbsp;&#124;&nbsp;&nbsp;<a href="<?php trackback_url(); ?>" rel="trackback"><?php _e('Trackback URL', 'uti_theme')?></a> </small>
<?php } ?>
</p><br />
<?php
// this line is WordPress' motor, do not delete it.
$commenter = wp_get_current_commenter();
extract($commenter);
$comments = get_approved_comments($id);
$post = get_post($id);
if ( post_password_required($post) ) {  // and it doesn't match the cookie
	echo(get_the_password_form());
} else { ?>

<?php if ($comments) { ?>
<ol id="commentlist">
<?php foreach ($comments as $comment) { ?>
	<li id="comment-<?php comment_ID() ?>">
	
	<div class="metadata"><p><?php comment_author_link() ?><br /><small><?php comment_date('m.d.y') ?>; <a href="#comment-<?php comment_ID() ?>"><?php comment_time() ?></a></small></p></div>
	<div class="comment-body"><?php comment_text() ?></div>
	</li>

<?php } // end for each comment ?>
</ol>
<?php } else { // this is displayed if there are no comments so far ?>
	<p><?php _e('No comments yet.', 'uti_theme')?></p>
<?php } ?>

<?php if ( comments_open() ) { ?>
<h2><?php _e('Leave a comment', 'uti_theme')?></h2>
<p><small><?php _e('Line and paragraph breaks automatic, e-mail address never displayed.', 'uti_theme')?></small></p><p><acronym title="Hypertext Markup Language">HTML</acronym> <?php _e('allowed:', 'uti_theme')?> <code><?php echo allowed_tags(); ?></code></p>

<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
<?php if ( $user_ID ) : ?>
	<p><?php _e('Logged in as', 'uti_theme')?> <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Log out of this account', 'uti_theme')?>"><?php _e('Log out', 'uti_theme')?> &raquo;</a></p>
<?php else : ?>
	<p>
	  <input type="text" name="author" id="author" class="textarea" value="<?php echo esc_attr($comment_author); ?>" size="28" tabindex="1" />
	   <label for="author">Name</label>
	</p>

	<p>
	  <input type="text" name="email" id="email" value="<?php echo esc_attr($comment_author_email); ?>" size="28" tabindex="2" />
	   <label for="email">E-mail</label>
	</p>

	<p>
	  <input type="text" name="url" id="url" value="<?php echo esc_attr($comment_author_url); ?>" size="28" tabindex="3" />
	   <label for="url"><abbr title="Universal Resource Locator">URL</abbr></label>
	</p>
<?php endif; ?>

	<p>
	  <label for="comment"><?php _e('Your Comment', 'uti_theme')?></label>
	<br />
	  <textarea name="comment" id="comment" cols="70" rows="4" tabindex="4"></textarea>
	</p>

	<p>
      <input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
	  <input type="hidden" name="redirect_to" value="<?php echo esc_attr($_SERVER["REQUEST_URI"]); ?>" />
	  <input name="submit" type="submit" tabindex="5" value="Say It!" />
	</p>
	<?php do_action('comment_form', $post->ID); ?>
</form>
<?php } else { // comments are closed ?>
<p><?php _e('Sorry, the comment form is closed at this time.', 'uti_theme')?></p>
<?php }
} // end password check
?>

<div><strong><a href="javascript:window.close()">Close this window.</a></strong></div>

<?php // if you delete this the sky will fall on your head
endwhile; //endwhile have_posts()
else: //have_posts()
?>
<p><?php _e('Sorry, no posts matched your criteria.', 'uti_theme')?></p>
<?php endif; ?>
<!-- // this is just the end of the motor - don't touch that line either :) -->
<?php //} ?>

<p class="credit"><cite><?php _e('Theme by', 'uti_theme')?> <a href="http://www.spaceperson.net/" title="<?php _e('Theme designed by', 'uti_theme')?> spaceperson.net"><strong>spaceperson</strong></a></cite></p>
<p class="credit"><?php timer_stop(1); ?> <cite><?php _e('Powered by', 'uti_theme')?> <a href="http://wordpress.org/" title="<?php _e('Powered by', 'uti_theme')?> WordPress"><strong>WordPress</strong></a></cite></p>
<?php // Seen at http://www.mijnkopthee.nl/log2/archive/2003/05/28/esc(18) ?>
<script type="text/javascript">
<!--
document.onkeypress = function esc(e) {
	if(typeof(e) == "undefined") { e=event; }
	if (e.keyCode == 27) { self.close(); }
}
// -->
</script>
</body>
</html>
